set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 6, panel B


**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	drop if D1_LP1_EMP==.

	*Standardize TFP 
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	
	
	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)

		
**2. Table 6, panel B
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T6_$col
				lincomest L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				estimates store own_$col
				est restore T6_$col
	end		
		
	local own 		"L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"
	local controls	"i.sectorgroup"


	**Column 1: Employment
		global col=1
		qui xi:areg D1_lnEMP  `own' `controls' [w=weight_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Column 2: Hours worked
		global col=2
		qui xi:areg D1_lnH_EMP  `own' `controls' [w=weight_h_c], absorb(ct) clus(ic)
			storeestimates

	**Column 3: Nominal wage bill
		global col=3
		qui xi:areg D1_lnLAB  `own'   `controls' [w=weight_h_c], absorb(ct) clus(ic) 
			storeestimates

	**Column 4: Nominal value added
		global col=4
		qui xi:areg D1_lnVA  `own' `controls' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Column 5: Real value added
		global col=5
		qui xi:areg D1_lnVA_QI  `own' `controls' [w=weight_VA_c], absorb(ct) clus(ic)
			storeestimates
			
	**Column 6: Laborshare
		global col=6
		qui xi:areg D1_lnlaborshare  `own'   `controls' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
			
	*Table
	esttab T6_1 T6_2 T6_3 T6_4 T6_5 T6_6, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 6, panel B")
	
	foreach var in own  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 6, panel B")
		}	
		
		

